unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, ComCtrls, Grids, Buttons, Crt, (*Beachte KeyPreview im Formular*)
  Process;

type

  { TFormsimpleGUIrsync }

  TFormsimpleGUIrsync = class(TForm)
    BitBtnStart: TBitBtn;
    ButtonDialogQuellpfad: TButton;
    ButtonAbbruch: TButton;
    ButtonDialogZielPfad: TButton;
    CheckBoxSimulation: TCheckBox;
    EditQuellpfad: TEdit;
    EditZielpfad: TEdit;
    EditBefehl: TEdit;
    LabelQuellPfad: TLabel;
    LabelZielpfad: TLabel;
    LabelBefehl: TLabel;
    MemoAnleitung: TMemo;
    PanelComputer: TPanel;
    Process: TProcess;
    SelectDirectoryDialog: TSelectDirectoryDialog;
    StatusBar: TStatusBar;
    procedure BitBtnStartClick(Sender: TObject);
    procedure ButtonAbbruchClick(Sender: TObject);
    procedure ButtonDialogZielPfadClick(Sender: TObject);
    procedure ButtonDialogQuellpfadClick(Sender: TObject);
    procedure CheckBoxSimulationChange(Sender: TObject);
    procedure EditZielpfadChange(Sender: TObject);
    procedure EditQuellpfadChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure Befehl(Sender: TObject);
    procedure LabelBefehlClick(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  FormsimpleGUIrsync: TFormsimpleGUIrsync;

  Parameter:            string;
  TextDatei:            TextFile;
  TextZeile:            string;

const
  Apostroph=#39;                                                                // ASCII-Tabelle
  Ausfuehrungszeichen=#34;

implementation

{$R *.lfm}

{ TFormsimpleGUIrsync }

(*--------------------------- StartBedingungen -------------------------------*)

procedure TFormsimpleGUIrsync.FormCreate(Sender: TObject);

begin
  Parameter          := '-auP ';
  EditBefehl.Text    := 'sudo rsync '+Parameter+EditQuellpfad.Text+' '
                                     +EditZielpfad.Text;
  ButtonAbbruch.Enabled:=false;
  AssignFile(TextDatei,'/tmp/simpleGUIrsync.sh');                               // /tmp
  Try                                                                           // Anlegen Skript für Rechte einstellen
    Rewrite(TextDatei);                                                         // hier günstig, da Rechte bei Rewrite erhalten bleiben!
    Except
      ShowMessage('Skript simpleGUIrsync.sh kann nicht anlegen werden! Bitte Verzeichnisse und Rechte prüfen!');
      Halt;
  end;

  TextZeile:='#!/bin/bash';
  WriteLN(Textdatei,TextZeile);
  CloseFile(TextDatei);

  Process.CommandLine:='chmod 777 /tmp/simpleGUIrsync.sh';                      // Recht einstellen /tmp
  Process.Active:=true;                                                         // eigentlicher Aufruf

  StatusBar.Panels[0].Text:='Programm simpleGUIrsync gestartet. Die Voreinstellungen sind optimal!';
end;

(*--------------------------- Befehl -----------------------------------------*)

procedure TFormsimpleGUIrsync.Befehl(Sender: TObject);

Begin
  EditBefehl.Text   := 'sudo rsync '+Parameter+EditQuellpfad.Text+' '
                                    +EditZielpfad.Text;
end;

(*--------------------------- QuellPfad --------------------------------------*)

procedure TFormsimpleGUIrsync.EditQuellpfadChange(Sender: TObject);
begin
  Befehl(Sender);
  StatusBar.Panels[0].Text:='QuellPfad geändert. Achte auf exakten QuellPfad!';
end;

(*--------------------------- ZielPfad ---------------------------------------*)

procedure TFormsimpleGUIrsync.EditZielpfadChange(Sender: TObject);
begin
  Befehl(Sender);
  StatusBar.Panels[0].Text:='ZielPfad geändert. Achte auf exakten ZielPfad!';
end;

(*--------------------------- Suche QuellPfad mit Dialog ---------------------*)

procedure TFormsimpleGUIrsync.ButtonDialogQuellpfadClick(Sender: TObject);
begin
  if SelectDirectoryDialog.Execute then
    begin
      EditQuellpfad.Text:=SelectDirectoryDialog.FileName;
      Befehl(Sender);
      StatusBar.Panels[0].Text:='QuellPfad mit Dialog eingestellt.';
    end;
end;

(*--------------------------- Suche ZielPfad mit Dialog ----------------------*)

procedure TFormsimpleGUIrsync.ButtonDialogZielPfadClick(Sender: TObject);
begin
  if SelectDirectoryDialog.Execute then
    begin
      EditZielpfad.Text:=SelectDirectoryDialog.FileName;
      Befehl(Sender);
      StatusBar.Panels[0].Text:='ZielPfad mit Dialog eingestellt.';
    end;
end;

(*--------------------------- Parameter -n -----------------------------------*)

procedure TFormsimpleGUIrsync.CheckBoxSimulationChange(Sender: TObject);
begin
  if CheckBoxSimulation.State = cbUnchecked Then Parameter:='-auP '
                                            Else Parameter:='-auPn ';
  Befehl(Sender);
  StatusBar.Panels[0].Text:='Parameter -n geändert.';
end;

(*--------------------------- Befehl einstellen ------------------------------*)

procedure TFormsimpleGUIrsync.LabelBefehlClick(Sender: TObject);
begin
  Befehl(Sender);
  StatusBar.Panels[0].Text:='Befehl wiederhergestellt.';
end;

(*--------------------------- rsync ------------------------------------------*)

procedure TFormsimpleGUIrsync.BitBtnStartClick(Sender: TObject);
begin
  If (EditZielpfad.Text='') or (EditQuellpfad.Text='') or
     (EditBefehl.Text='') Then
  MessageDlg('Fehler: Eingaben unvollständig!',mtInformation,[mbOK],0)
                          Else
  Begin
    Try                                                                         // Anlegen Skript
      Rewrite(TextDatei);
      Except
        ShowMessage('Skript simpleGUIrsync.sh kann nicht anlegen werden! Bitte Verzeichnisse und Rechte prüfen!');
        Halt;
    end;

    TextZeile:='#!/bin/bash';
    WriteLN(TextDatei,TextZeile);
    TextZeile:='# R.I.P.   ><>';
    WriteLN(Textdatei,TextZeile);
    TextZeile:='echo Start Skript simpleGUIrsync.sh - Bitte haben Sie etwas Geduld!';
    WriteLN(Textdatei,TextZeile);
    TextZeile:='echo Befehl: '+EditBefehl.Text;
//    ShowMessage('Befehl: '+EditBefehl.Text);
    WriteLN(Textdatei,TextZeile);
    TextZeile:='echo';
    WriteLN(Textdatei,TextZeile);

    TextZeile:=EditBefehl.Text;
    WriteLN(Textdatei,TextZeile);

    TextZeile:='echo';
    WriteLN(Textdatei,TextZeile);
    TextZeile:='echo Ende Skript simpleGUIrsync.sh - Danke für die Benutzung!';
    WriteLN(Textdatei,TextZeile);

    CloseFile(TextDatei);
    ButtonAbbruch.Enabled := true;
//    ShowMessage('Haltepunkt nach Rewrite einstellen');
    Process.CommandLine:='xterm -hold -sb -right -geometry 180x50 -e /tmp/./simpleGUIrsync.sh';
    Process.Active:=true;                                                       // eigentlicher Aufruf

    StatusBar.Panels[0].Text:='Suche gestartet. Gedrückte Maustaste im Terminal-Fenster hält Suche an! Click auf x im Terminal-Fenster beendet Suche!   ><>';
  end;
end;

(*--------------------------- Abbruch ----------------------------------------*)

procedure TFormsimpleGUIrsync.ButtonAbbruchClick(Sender: TObject);
begin
  Process.Active:=false;
  ButtonAbbruch.Enabled:=false;
  StatusBar.Panels[0].Text:='Ende / Abbruch angefordert.';
end;

end.

